<?php

namespace App\Http\Controllers\Therapists;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Broadcast;
use App\Http\Requests\Therapists\TherapistBroadcasts\CreateRequest;
use App\Http\Resources\Web\BroadcastsResource;
use Excel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistBroadcastsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
      $this->middleware('auth');
      $this->middleware('therapist');
      // $this->middleware('permission:therapist_broadcasts.index');
      // $this->middleware('permission:therapist_broadcasts.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_broadcasts.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_broadcasts.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_broadcasts.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_broadcasts.import',['only' => ['import']])
      // $this->middleware('permission:therapist_broadcasts.update|therapist_broadcasts.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist = auth()->user()->therapist;
    if($req != null){
      $therapist_broadcasts =  $therapist->therapist_broadcasts()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_broadcasts =  $therapist_broadcasts->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_broadcasts =  $therapist_broadcasts->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_broadcasts = $therapist_broadcasts->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_broadcasts = $therapist_broadcasts->whereLike(['name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_broadcasts = $therapist_broadcasts->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_broadcasts = $therapist_broadcasts->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_broadcasts = $therapist_broadcasts->get();
        return $therapist_broadcasts;
      }
      $totalTherapistBroadcasts = $therapist_broadcasts->count();
      $therapist_broadcasts = $therapist_broadcasts->paginate($req->perPage);
      $therapist_broadcasts = BroadcastsResource::collection($therapist_broadcasts)->response()->getData(true);

      return $therapist_broadcasts;
    }
    $therapist_broadcasts = BroadcastsResource::collection($therapist->therapist_broadcasts()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_broadcasts;
  }

  /********* FETCH ALL TherapistBroadcasts ***********/
    public function index()
    {
        $therapist_broadcasts =  $this->getter();
        $response = generateResponse($therapist_broadcasts,count($therapist_broadcasts['data']) > 0 ? true:false,'TherapistBroadcasts Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER TherapistBroadcasts FOR Search ***********/
   public function filter(Request $request){
     $therapist_broadcasts = $this->getter($request);
     $response = generateResponse($therapist_broadcasts,count($therapist_broadcasts['data']) > 0 ? true:false,'Filter TherapistBroadcasts Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW TherapistBroadcast ***********/
    public function store(CreateRequest $request)
    {
      $therapist = auth()->user()->therapist;
      try{
      DB::beginTransaction();
      $request->merge(['created_by_user_id'=>auth()->user()->id]);
      $data = $request->all();
      $data['image'] = uploadCroppedFile($request,'image','therapist_broadcasts');
      $data['audio'] = uploadFile($request,'audio','therapist_broadcasts');
      $data['video'] = uploadFile($request,'video','therapist_broadcasts');
      $therapist_broadcast = $therapist->therapist_broadcasts()->create($data);
      $therapist_broadcast->slug = Str::slug($therapist_broadcast->name . ' ' . $therapist_broadcast->id, '-');
      $therapist_broadcast->save();
      $therapist_broadcast->tags()->sync($request->tag_ids);
      $therapist_broadcast = $therapist->therapist_broadcasts()->withAll()->find($therapist_broadcast->id);
      $therapist_broadcast = new BroadcastsResource($therapist_broadcast);
      DB::commit();
    }
      catch (\Exception $e) {
        dd($e->getMessage());
        DB::rollBack();
        request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
     }
      return redirect()->back();
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show( $therapist_broadcast)
    {
        $therapist = auth()->user()->therapist;
        if($therapist_broadcast->therapist_id != $therapist->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_broadcast = $therapist->therapist_broadcasts()->withAll()->find($therapist_broadcast);
        if($therapist_broadcast){
          $therapist_broadcast = new BroadcastsResource($therapist_broadcast);
          $response = generateResponse($therapist_broadcast,true,'TherapistBroadcast Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'TherapistBroadcast Not FOund',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistBroadcast ***********/
    public function update(CreateRequest $request, Broadcast $therapist_broadcast)
    {
        // dd($request->all());
        $therapist = auth()->user()->therapist;
        if($therapist_broadcast->therapist_id != $therapist->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->image) {
            $data['image'] = uploadCroppedFile($request,'image','therapist_broadcasts',$therapist_broadcast->image);
        } else {
            $data['image'] = $therapist_broadcast->image;
        }

        if ($request->audio) {
            $data['audio'] = uploadFile($request,'audio','therapist_broadcasts');
        } else {
            $data['audio'] = $therapist_broadcast->audio;
        }

        if ($request->video) {
            $data['video'] = uploadFile($request,'video','therapist_broadcasts');
        } else {
            $data['video'] = $therapist_broadcast->video;
        }
        $therapist_broadcast->update($data);
        $therapist_broadcast = Broadcast::find($therapist_broadcast->id);
        $slug = Str::slug($therapist_broadcast->name . ' ' . $therapist_broadcast->id, '-');
        $therapist_broadcast->update([
            'slug' => $slug
        ]);
         $therapist_broadcast->tags()->sync($request->tag_ids);
        DB::commit();
      }
        catch (\Exception $e) {
          DB::rollBack();
          request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
       }
       return redirect()->back();
    }

    /********* UPDATE TherapistBroadcast Status***********/
    public function updateStatus(Request $request,Broadcast $therapist_broadcast){
        $therapist = auth()->user()->therapist;
        if($therapist_broadcast->therapist_id != $therapist->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_broadcast->update([
          'is_active' => $therapist_broadcast->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'TherapistBroadcast Status Updated Successfully',null,'object');
        return response()->json($response, 200);
    }


    /********* DELETE TherapistBroadcast ***********/
    public function destroy(Request $request,Broadcast $therapist_broadcast)
    {
        $therapist = auth()->user()->therapist;
        if($therapist_broadcast->therapist_id != $therapist->id){
            request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
            return redirect()->back();
        }
          if($therapist_broadcast->trashed()) {
            request()->session()->flash('alert',['message' => 'Already in Trash','type' => 'error']);
          }
          else{
            $therapist_broadcast->delete();
          }
          return redirect()->back();
    }
    /*********Permanently DELETE TherapistBroadcast ***********/
    public function destroyPermanently(Request $request,$therapist_broadcast)
    {
        $therapist= auth()->user()->therapist;
        $therapist_broadcast = $therapist->therapist_broadcasts()->withTrashed()->find($therapist_broadcast);
        if($therapist_broadcast){
            if($therapist_broadcast->therapist_id != $therapist->id){
                return redirect()->back()->withErrors([
                    'message' => 'Invalid Request',
                    'type' => 'error'
                ]);
            }
          if ($therapist_broadcast->trashed()) {
            $therapist_broadcast->forceDelete();
            $response = generateResponse(null,true,'TherapistBroadcast Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistBroadcast is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'TherapistBroadcast not found',null,'object');
        }
          return response()->json($response, 200);
    }
    /********* Restore TherapistBroadcast ***********/
    public function restore(Request $request,$therapist_broadcast)
    {
      $therapist= auth()->user()->therapist;
      $therapist_broadcast = $therapist->therapist_broadcasts()->withTrashed()->find($therapist_broadcast);
          if ($therapist_broadcast->trashed()) {
            $therapist_broadcast->restore();
            $response = generateResponse(null,true,'TherapistBroadcast Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistBroadcast is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
